﻿/*var Pivot = function () {
    var init = function (selector, sectionId, data, canUsersDefineReports, dotnetInstance, template, isDesign) {
        data = JSON.parse(data);
        if (!template) {
            template = {
                formats: [
                    {
                        name: "",
                        decimalPlaces: 2,
                        thousandsSeparator: '.',
                        decimalSeparator: ','
                    }
                ],
                dataSource: {
                    dataSourceType: "json",
                    data: data
                }
            };
        }
        else {
            template = JSON.parse(template);
            template.dataSource = {
                dataSourceType: "json",
                data: data
            };
        }

        var pivot = new WebDataRocks({
            container: selector,
            beforetoolbarcreated: customizeToolbar,
            toolbar: true,
            global: {
                localization: "/lib/webdatarocks/tr.json"
            }
        });

        pivot.setReport(template);

        function customizeToolbar(toolbar) {
            var tabs = toolbar.getTabs();
            toolbar.getTabs = function () {
                delete tabs[0];
                delete tabs[1];
                delete tabs[2];

                if (isDesign) {
                    delete tabs[3];
                }

                if (canUsersDefineReports && isDesign === false) {
                    tabs.unshift({
                        id: "wdr-tab-default",
                        title: "Kaydet",
                        handler: newtabHandlerSave,
                        icon: this.icons.save
                    });
                }

                return tabs;
            }

            var newtabHandlerSave = function () {
                dotnetInstance.invokeMethodAsync("OpenUserDefinedReportPopup", sectionId);
            };
        }
    };

    var remove = function () {
        $("#wdr-pivot").remove();
        $(".wdr-resize-triggers").remove();
    };
    var getReport = function () {
        var template = webdatarocks.getReport();
        delete template.dataSource;

        return JSON.stringify(template);
    };
    return {
        init: function (selector, sectionId, data, canUsersDefineReports, dotnetInstance, reportDesign, isDesign) {
            init(selector, sectionId, data, canUsersDefineReports, dotnetInstance, reportDesign, isDesign);
        },
        remove: function () {
            remove();
        },
        getReport: function () {
            return getReport();
        }
    };
}();*/

function poolColors(a) {
    var dynamicColors = function () {
        var r = Math.floor(Math.random() * 255);
        var g = Math.floor(Math.random() * 255);
        var b = Math.floor(Math.random() * 255);
        return "rgba(" + r + "," + g + "," + b + ", 0.5)";
    }

    var pool = [];
    for (i = 0; i < a; i++) {
        pool.push(dynamicColors());
    }
    return pool;
}

var ChartFunc = function () {
    var initPie = function (selector, type, dt, labelColumn, dataColumn) {
        var ctx = document.getElementById(selector);

        var arrData = dt.map(function (x) { return x[dataColumn]; });
        var labels = dt.map(function (x) { return x[labelColumn]; });

        var chartObj = new Chart(ctx, {
            type: type,
            data: {
                labels: labels,
                datasets: [{
                    data: arrData,
                    backgroundColor: poolColors(arrData.length)
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false
            }
        });
    };
    var initSerie = function (selector, type, labels, dt, labelColumn, dataColumn, serieColumn) {
        var ctx = document.getElementById(selector);
        var tData = type.split(";");

        var datasets = [];

        if (dt && dt.length > 0 && dt[0].data && dt[0].data.length > 0) {
            let keys = Object.keys(dt[0].data[0]);
            if (keys.indexOf(labelColumn) < 0 || keys.indexOf(dataColumn) < 0  /*|| keys.indexOf(serieColumn) < 0*/) {
                return false;
            }
        }

        for (var i = 0; i < dt.length; i++) {
            for (var j = 0; j < labels.length; j++) {
                let found = dt[i].data.some(el => el[labelColumn] === labels[j]);
                if (found == false) {
                    let d = {};
                    d[labelColumn] = labels[j];
                    d[dataColumn] = 0;

                    dt[i].data.push(d);
                }
            }

            //dt[i].data.sort(function (a, b) {
            //    return a[labelColumn].localeCompare(b[labelColumn]);
            //});

            var arrData = dt[i].data.map(function (x) { return x[dataColumn]; });

            var colors = poolColors(arrData.length);
            let dataset = {
                label: dt[i].serieName ? dt[i].serieName : "",
                data: arrData,
                backgroundColor: colors,
                borderColor: colors,
                borderWidth: tData[0] == "line" ? 4 : 1
            };

            datasets.push(dataset);
        }

        var options = {
            responsive: true,
            maintainAspectRatio: false,
            scales: {
                y: {
                    beginAtZero: true
                },
                x: {
                    ticks: {
                        maxRotation: 80,
                        minRotation: 80
                    }
                }
            },
            plugins: {
                legend: {
                    display: serieColumn ? true : false
                }
            }
        };

        if (tData.length > 1 && tData[1] == "horizontal")
            options.indexAxis = 'y';

        var chartObj = new Chart(ctx, {
            type: tData[0],
            data: {
                labels: labels,
                datasets: datasets
            },
            options: options
        });

        return true;
    };
    var removeAllInstances = function () {
        Chart.helpers.each(Chart.instances, function (instance) {
            instance.destroy();
        })
    };
    var removeInstance = function (id) {
        Chart.helpers.each(Chart.instances, function (instance) {
            if(instance.canvas.id === id)
                instance.destroy();
        })
    };
    return {
        initPie: function (selector, type, data, labelColumn, dataColumn) {
            initPie(selector, type, data, labelColumn, dataColumn);
        },
        initSerie: function (selector, type, labels, data, labelColumn, dataColumn, serieColumn) {
            return initSerie(selector, type, labels, data, labelColumn, dataColumn, serieColumn);
        },
        removeAllInstances: function () {
            removeAllInstances();
        },
        removeInstance: function (id) {
            removeInstance(id);
        }
    };
}();

var CodeEditor = function () {
    var init = function () {
        if (!window.editors)
            window.editors = [];

        ace.require("ace/ext/language_tools");
        var elements = document.getElementsByClassName("editor-size-small");

        for (var i = 0; i < elements.length; i++) {
            var element = elements[i];
            if (!window.editors.includes(element.id)) {
                var editor = ace.edit(element);
                editor.setOptions({
                    mode: 'ace/mode/sql',
                    maxLines: 25,
                    showLineNumbers: true,
                    enableBasicAutocompletion: true
                });

                window.editors.push(element.id);
            }
        }
    };
    var getValue = function (selector) {
        var editor = ace.edit(selector);
        if (editor) {
            return editor.getValue();
        }
    };
    var setValue = function (selector, value) {
        var editor = ace.edit(selector);
        if (editor) {
            editor.setValue(value, -1);
        }
    };
    var beautify = function (selector) {
        let beautify = window.ace.require('ace/ext/beautify');

        var editor = ace.edit(selector);
        if (editor) {
            beautify.beautify(editor.session);
        }
    };
    var formatSql = function (selector) {
        var txt = getValue(selector);
        var format = window.sqlFormatter.format;

        var editor = ace.edit(selector);
        if (editor) {
            return editor.setValue(format(txt, {
                language: "sql",
                indent: '   '
            }), -1);
        }
    };
    return {
        init: function () {
            init();
        },
        getValue: function (selector) {
            return getValue(selector);
        },
        setValue: function (selector, value) {
            setValue(selector, value);
        },
        beautify: function (selector) {
            beautify(selector);
        },
        formatSql: function (selector) {
            formatSql(selector);
        }
    };
}();

var BlockUI = function () {
    $.fn.center = function () {
        this.css("position", "absolute");
        this.css("top", ($(window).height() - this.height()) / 2 + $(window).scrollTop() + "px");
        this.css("left", ($(window).width() - this.width()) / 2 + $(window).scrollLeft() + "px");
        return this;
    }

    var block = function (selector) {
        var css = {
            css: {
                backgroundColor: 'transparent',
                border: 'none'
            },
            message: '<div class="spinner"></div>',
            baseZ: 1500,
            overlayCSS: {
                backgroundColor: '#FFFFFF',
                opacity: 0.7,
                cursor: 'wait'
            }
        };

        if (selector)
            $("#" + selector).block(css);
        else {
            $.blockUI(css);
            //$('.blockUI.blockMsg').center();
        }
    };
    var unblock = function (selector) {
        if (selector)
            $("#" + selector).unblock();
        else
            $.unblockUI();
    };
    return {
        block: function (selector) {
            return block(selector);
        },
        unblock: function (selector) {
            return unblock(selector);
        }
    };
}();

var TagCompEmail = function () {
    var initEmail = function (maxItems) {
        var options = {
            pattern: /^(([^<>()\[\]\\.,;:\s@"]+(\.[^<>()\[\]\\.,;:\s@"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/,
            dropdown: {
                position: 'text',
                enabled: 1
            },
            duplicates: false
        };

        if (maxItems) {
            options.maxTags = maxItems;
        }

        var input = document.querySelector('.email-tag'),
            tagify = new Tagify(input, options),
            button = input.nextElementSibling;

        button.addEventListener("click", onAddButtonClick);

        function onAddButtonClick() {
            tagify.addEmptyTag();
        }

        window.emailTagify = tagify;
    };
    var addEmail = function (tag) {
        window.emailTagify.addTags(tag);
    };
    var getEmails = function () {
        return window.emailTagify.value.map(a => a.value);
    };
    return {
        initEmail: function (maxItems) {
            initEmail(maxItems);
        },
        addEmail: function (tag) {
            addEmail(tag);
        },
        getEmails: function () {
            return getEmails();
        }
    };
}();

/*var ExcelTable = function () {
    var init = function (selector, data) {
        data = JSON.parse(data);

        let columns = [];
        columnNames = data.length == 0 ? ["Result"] : Object.keys(data[0]);

        for (let i in columnNames) {
            columns.push({ data: columnNames[i], title: columnNames[i] });
        }

        const container = document.querySelector(selector);

        const hot = new Handsontable(container, {
            data: data,
            colHeaders: columnNames,
            rowHeaders: true,
            width: '100%',
            height: 700,
            contextMenu: true,
            manualColumnFreeze: true,
            manualColumnResize: true,
            dropdownMenu: true,
            filters: true,
            hiddenRows: true,
            columnSorting: true,
            hiddenColumns: {
                indicators: true
            },
            licenseKey: 'non-commercial-and-evaluation' // for non-commercial use only
        });
    };
    var remove = function () {
        $("#datatable_wrapper").remove();
    };

    var excel = function () {
        function toDay() {
            var today = new Date();
            var dd = today.getDate();
            var mm = today.getMonth() + 1;

            var yyyy = today.getFullYear();
            if (dd < 10) {
                dd = '0' + dd;
            }
            if (mm < 10) {
                mm = '0' + mm;
            }
            return dd + '.' + mm + '.' + yyyy;
        }

        function exportTableToExcel(tableClass) {
            var downloadLink;
            var dataType = 'application/vnd.ms-excel';
            //var tableSelect = document.getElementById(tableID);
            var tableSelect = document.getElementsByClassName(tableClass)[0];
            var tableHTML = tableSelect.outerHTML.replace(/ /g, '%20');

            // Specify file name
            var filename = 'Export_' + toDay() + '.xls';

            // Create download link element
            downloadLink = document.createElement("a");

            document.body.appendChild(downloadLink);

            if (navigator.msSaveOrOpenBlob) {
                var blob = new Blob(['\ufeff', tableHTML], {
                    type: dataType
                });
                navigator.msSaveOrOpenBlob(blob, filename);
            } else {
                // Create a link to the file
                downloadLink.href = 'data:' + dataType + ', ' + tableHTML;
                // Setting the file name
                downloadLink.download = filename;
                //triggering the function
                downloadLink.click();
            }
        }

        var tableClass = 'htCore';
        exportTableToExcel('' + tableClass + '');
    };
    return {
        init: function (selector, data, userFiltering, useOrdering, pageLength) {
            init(selector, data, userFiltering, useOrdering, pageLength);
        },
        remove: function () {
            remove();
        },
        excel: function () {
            excel();
        }
    };
}();*/

var Onboarding = function () {
    var init = function () {
        $('body').chardinJs();
    };
    var run = function () {
        if ($('.page-content div').is(':visible')) {
            return ($('body').data('chardinJs')).toggle();
        } else {
            return $('.page-content div').animate({
                height: 250
            }, 600, function () {
                return ($('body').data('chardinJs')).toggle();
            });
        }
    };
    return {
        init: function () {
            init();
        },
        run: function () {
            return run();
        }
    };
}();

var App2 = function () {
    var isIE8 = false;
    var isIE9 = false;
    var isIE10 = false;

    var resizeHandlers = [];

    var handleInit = function () {

        if ($('body').css('direction') === 'rtl') {
            isRTL = true;
        }

        isIE8 = !!navigator.userAgent.match(/MSIE 8.0/);
        isIE9 = !!navigator.userAgent.match(/MSIE 9.0/);
        isIE10 = !!navigator.userAgent.match(/MSIE 10.0/);

        if (isIE10) {
            $('html').addClass('ie10'); // detect IE10 version
        }

        if (isIE10 || isIE9 || isIE8) {
            $('html').addClass('ie'); // detect IE10 version
        }
    };
    var _runResizeHandlers = function () {
        // reinitialize other subscribed elements
        for (var i = 0; i < resizeHandlers.length; i++) {
            var each = resizeHandlers[i];
            each.call();
        }
    };
    var handleOnResize = function () {
        var windowWidth = $(window).width();
        var resize;
        if (isIE8) {
            var currheight;
            $(window).resize(function () {
                if (currheight == document.documentElement.clientHeight) {
                    return; //quite event since only body resized not window.
                }
                if (resize) {
                    clearTimeout(resize);
                }
                resize = setTimeout(function () {
                    _runResizeHandlers();
                }, 50); // wait 50ms until window resize finishes.                
                currheight = document.documentElement.clientHeight; // store last body client height
            });
        } else {
            $(window).resize(function () {
                if ($(window).width() != windowWidth) {
                    windowWidth = $(window).width();
                    if (resize) {
                        clearTimeout(resize);
                    }
                    resize = setTimeout(function () {
                        _runResizeHandlers();
                    }, 50); // wait 50ms until window resize finishes.
                }
            });
        }
    };
    var handleModals = function () {
        // fix stackable modal issue: when 2 or more modals opened, closing one of modal will remove .modal-open class. 
        $('body').on('hide.bs.modal', function () {
            if ($('.modal:visible').size() > 1 && $('html').hasClass('modal-open') === false) {
                $('html').addClass('modal-open');
            } else if ($('.modal:visible').size() <= 1) {
                $('html').removeClass('modal-open');
            }
        });

        // fix page scrollbars issue
        $('body').on('show.bs.modal', '.modal', function () {
            if ($(this).hasClass("modal-scroll")) {
                $('body').addClass("modal-open-noscroll");
            }
        });

        // fix page scrollbars issue
        $('body').on('hidden.bs.modal', '.modal', function () {
            $('body').removeClass("modal-open-noscroll");
        });

        // remove ajax content and remove cache on modal closed 
        $('body').on('hidden.bs.modal', '.modal:not(.modal-cached)', function () {
            $(this).removeData('bs.modal');
        });
    };
    var handleHeight = function () {
        $('[data-auto-height]').each(function () {
            var parent = $(this);
            var items = $('[data-height]', parent);
            var height = 0;
            var mode = parent.attr('data-mode');
            var offset = parseInt(parent.attr('data-offset') ? parent.attr('data-offset') : 0);

            items.each(function () {
                if ($(this).attr('data-height') == "height") {
                    $(this).css('height', '');
                } else {
                    $(this).css('min-height', '');
                }

                var height_ = (mode == 'base-height' ? $(this).outerHeight() : $(this).outerHeight(true));
                if (height_ > height) {
                    height = height_;
                }
            });

            height = height + offset;

            items.each(function () {
                if ($(this).attr('data-height') == "height") {
                    $(this).css('height', height);
                } else {
                    $(this).css('min-height', height);
                }
            });

            if (parent.attr('data-related')) {
                $(parent.attr('data-related')).css('height', parent.height());
            }
        });
    };

    return {
        init: function () {
            handleInit();
            handleOnResize();
            handleModals();

            this.addResizeHandler(handleHeight);
        },
        addResizeHandler: function (func) {
            resizeHandlers.push(func);
        },
        runResizeHandlers: function () {
            _runResizeHandlers();
        }
    };
}();

function gotoAnchor(anchor) {
    $(document).scrollTop($('#' + anchor).offset().top);
}

function saveAsFile(filename, bytesBase64) {
    var link = document.createElement('a');
    link.download = filename;
    link.href = "data:application/octet-stream;base64," + bytesBase64;
    document.body.appendChild(link);
    link.click();
    document.body.removeChild(link);
}

function saveAsJsonFile(filename, json) {
    var link = document.createElement('a');
    link.download = filename;
    link.href = URL.createObjectURL(new Blob([json], {
        type: "text/plain"
    }));
    document.body.appendChild(link);
    link.click();
    document.body.removeChild(link);
}

function BlazorDownloadFile(filename, contentType, content) {
    // Create the URL
    const file = new File([content], filename, { type: contentType });
    const exportUrl = URL.createObjectURL(file);

    // Create the <a> element and click on it
    const a = document.createElement("a");
    document.body.appendChild(a);
    a.href = exportUrl;
    a.download = filename;
    a.target = "_self";
    a.click();

    // We don't need to keep the object URL, let's release the memory
    // On older versions of Safari, it seems you need to comment this line...
    URL.revokeObjectURL(exportUrl);
}

window.downloadFileFromStream = async (fileName, contentStreamReference) => {
    const arrayBuffer = await contentStreamReference.arrayBuffer();
    const blob = new Blob([arrayBuffer], { type: "application/octet-stream" });
    const url = URL.createObjectURL(blob);
    const anchorElement = document.createElement('a');
    anchorElement.href = url;
    anchorElement.download = fileName ?? '';
    anchorElement.click();
    anchorElement.remove();
    URL.revokeObjectURL(url);
  }

function getUrl() {
    return window.location.protocol + '//' + window.location.host;
}

function stopPropagation(evt) {
    if (evt.stopPropagation !== undefined) {
        evt.stopPropagation();
    } else {
        evt.cancelBubble = true;
    }
}

function collapseSidebar() {
    if (!$(".sidebar-main").hasClass("sidebar-main-resized")) {
        $(".sidebar-main").addClass("sidebar-main-resized");
    }
}

function expandSidebar() {
    if ($(".sidebar-main").hasClass("sidebar-main-resized")) {
        $(".sidebar-main").removeClass("sidebar-main-resized");
    }
}

function chatHistoryScrollToLast() {
    $(".chat-history .card").last()[0].scrollIntoView({ behavior: 'smooth' });
}

var askToAiWaitingMsgs = [];
var askToAiWaitingElapsed = 0;
var askToAiCounter = 0;
var askToAiMsg = '';
var askToAiSpeed = 50;
var askToAiDomId = "aiWaitingMsg";

function loadAskToAiWaitingMsgs(key, path) {
    $.ajax({
        'async': false,
        'global': false,
        'url': path,
        'dataType': "json",
        'success': function (data) {
            askToAiWaitingMsgs[key] = data;
        }
    });
}

function showAiWaitingMsg() {
    askToAiWaitingElapsed = askToAiWaitingElapsed + 10000;

    if (askToAiWaitingElapsed <= 30) {
        askToAiMsg = askToAiWaitingMsgs["030"][Math.floor(Math.random() * askToAiWaitingMsgs["030"].length)].msg;
    }
    else if (askToAiWaitingElapsed > 30 && askToAiWaitingElapsed <= 60) {
        askToAiMsg = askToAiWaitingMsgs["060"][Math.floor(Math.random() * askToAiWaitingMsgs["060"].length)].msg;
    }
    else if (askToAiWaitingElapsed > 60) {
        askToAiMsg = askToAiWaitingMsgs["120"][Math.floor(Math.random() * askToAiWaitingMsgs["120"].length)].msg;
    }

    askToAiCounter = 0;
    let dom = document.getElementById(askToAiDomId);
    if (dom) {
        dom.innerHTML = null;
    }
    typeWriter();
}

function stopShowingAiWaitingMsgs(intervalID) {
    clearInterval(intervalID);
}

function sendMsgToAi() {
    askToAiCounter = 0;
    askToAiMsg = askToAiWaitingMsgs["030"][Math.floor(Math.random() * askToAiWaitingMsgs["030"].length)].msg;
    let dom = document.getElementById(askToAiDomId);
    if (dom) {
        dom.innerHTML = null;
    }
    typeWriter();

    askToAiWaitingElapsed = 0;
    let intervalID = setInterval(showAiWaitingMsg, 10000);
    return intervalID;
}

function typeWriter() {
    if (askToAiCounter < askToAiMsg.length) {
        let dom = document.getElementById(askToAiDomId);
        if (dom) {
            dom.innerHTML += askToAiMsg.charAt(askToAiCounter);
            askToAiCounter++;
            setTimeout(typeWriter, askToAiSpeed);
        }
    }
}

function clearAiSteps() {
    document.getElementById("aistepbg3").className = "bg-muted bg-opacity-10 text-muted lh-1 rounded-pill p-2";
    document.getElementById("aistepbg4").className = "bg-muted bg-opacity-10 text-muted lh-1 rounded-pill p-2";
    document.getElementById("aistepbg5").className = "bg-muted bg-opacity-10 text-muted lh-1 rounded-pill p-2";

    document.getElementById("aistepi3").className = "ph ph-hourglass";
    document.getElementById("aistepi4").className = "ph ph-hourglass";
    document.getElementById("aistepi5").className = "ph ph-hourglass";
}

function setAiStep(step) {
    document.getElementById("aistepbg" + step).className = "bg-success bg-opacity-10 text-success lh-1 rounded-pill p-2";
    document.getElementById("aistepi" + step).className = "ph ph-check";
}

function checkIsElementExists(id) {
    return $('#' + id).length > 0;
}

function formatSql(query) {
    var format = window.sqlFormatter.format;
    return format(query, {
        language: "sql",
        indent: '   '
    });
}

function copyClipboard(elementId) {
    var copyText = document.getElementById(elementId);
    copyText.select();
    document.execCommand("copy");
}

window.expandMonacoEditor = () => {
    document.getElementById('sql-editor').classList.add('monaco-fix-height');
    //document.getElementById('sql-editor').classList.remove('monaco-fix-height');
    document.getElementById('rq-sql-editor').classList.add('rq-sql-editor-expanded');

    editor.layout();
};

window.closeMonacoEditor = () => {
    document.getElementById('rq-sql-editor').classList.remove('rq-sql-editor-expanded');

};

jQuery(document).ready(function () {
    //App.init();
});